/*
 * This File is one of the examples from Java Object Oriented Programming
 * Do not reproduce this code for others or use it in a commercial setting without prior permission from the author.
 */
package salesApplicationFinal;

import java.util.function.Consumer;
import java.util.function.Predicate;
import products.*;
import static products.Pen.PenType.FELTTIP;

/**
 *
 * @author Matthew Gregory
 * @website www.matthewgregory-author.com.au
 *
 */
public class TestPriceList {

    public static void main(String[] args) {
        PriceList demo = (new InMemoryDataSource()).retrieveList("Demo");
//        demo.printList(); 

        //The eariler examples 1-5 can be found in the salesApplicationInnerClasses package.
        //6.  Using JavaSE8's  interface.
//        class LocalCondition implements Predicate<Item>{
//                public boolean test(Item i) {
//                    return (i instanceof WritingImplement);
//                }
//        }
//        LocalCondition filter = new LocalCondition();
//        demo.filterList(filter).printList();
        //6.  Using anonymous inner classes to do tall three steps at once!
        //Doing the instance creation in the method call.
//        class LocalCondition implements GenericFilter<Item>{
//            public boolean test(Item i) {
//                return (i instanceof WritingImplement);
//            }
//        }
//        LocalCondition filter = new LocalCondition();
//        demo.filterList(
//                new LocalCondition()
//        ).printList();
        //Defining the class and doing the instance creation in the method call.
//        demo.filterList(
//                new GenericFilter<Item>(){
//                    public boolean test(Item i) {
//                        return (i instanceof WritingImplement);
//                    }
//                }
//        ).printList();
        //7.  Complex and messy, just to pass across a condition - use lambda instead.
//        demo.filterList(i-> i instanceof WritingImplement).printList();
        /**
         * ** How Lambda's Work ****
         */
        //Wrong type of Lambda expression
//        demo.filterList(
//                i-> {System.out.println("Item name: "+i.getName()+" Price: "+i.getPrice());}
//        ).printList();
        //Note:  In a different context this lambda expression is valid.
//        demo.list.forEach(
//                i-> {System.out.println("Item name: "+i.getName()+" Price: "+i.getPrice());}
//        );
        //Using {} example.
        //demo.filterList(i-> {return(i.getPrice() > 5);}).printList();
        //Calling a method that requires a lambda
//        demo.list.forEach(i->{
//            System.out.println("Name: "+i.getName());
//            System.out.println("Price: "+i.getFormattedPrice());
//            });
        //Using casting to reference more specific details
//        demo.list.forEach(i->{
//            //Check item is a pen
//            if (i instanceof Pen){
//                //Check the pen type
//                if (((Pen) i).type.equals(FELTTIP)){
//                    System.out.println("Name: "+i.getName());
//                    System.out.println("Price: "+i.getFormattedPrice());
//                }
//            }
//            });
        //Programming methods to use Lambda
//        demo.applyDiscount(
//                (i) -> {
//                    if (i instanceof WritingImplement) {
//                        i.setPrice(i.getPrice() * 0.9);
//                    }
//                    return i;
//                }).printList();

    }
}
